/*
 *----------------------------------------------------------------------------
 *	LSI Corporation
 *	1621 Barber Lane
 *	Milpitas, California 95035
 *----------------------------------------------------------------------------
 * Copyright  2004-2006, LSI Corporation All Rights Reserved.
 * LSI's source code is an unpublished work and the use of copyright
 * notice does not imply otherwise. This source code contains confidential,
 * trade secret material of LSI Corporation. Any attempt or
 * participation in deciphering, decoding, reverse engineering or
 * in any way altering the source code is strictly prohibited, unless the
 * prior written consent of LSI Corporation.
 *
 * * File Name	: lin_defs.h (Common project-wide definitions for Linux)
 * Description	:
 * This file can and will be inlcuded by every other file in this project.
 * Only the most common project-wide definitions must go into this header.
 * This lin_defs.h header will include system header files for Linux.
 * No HAL, RAID, INTERFACE or PROTOCOL specific information 
 * will be included here.
 *
 *
 *----------------------------------------------------------------------------
 */

#ifndef LSI_MEGA_SWR_LINUX_DEFS_H
#define LSI_MEGA_SWR_LINUX_DEFS_H

#ifdef __LP64__
#define COMPILE_64BIT
#endif

#ifndef COMPILE_64BIT
uint64_t megasr_div64(uint64_t dividend, uint32_t divisor);
uint32_t megasr_mod64(uint64_t dividend, uint32_t divisor);
#endif
int megasr_printk(const char *fmt, ...);

typedef unsigned long		addr_t;
#define INLINE				inline

#include "../../cmn_list.h"

#define LSIRAID_OS_NAME			"Linux"
#define	LSIRAID_OS_VERSION		"unknown"
#define LSIRAID_OS_NAME_LEN		sizeof(LSIRAID_OS_NAME)
#define LSIRAID_OS_VER_LEN		sizeof(LSIRAID_OS_VERSION)

/*
* Define global OS specific macros
*/

/* con_log is used for error/warning/info/announce and it will be present 
* in free build driver. All debug information should be strictly con_dbg
*/
//#define con_log(lvl, fmt) if(lvl & dbglvl_g)	printk fmt
#define con_log(lvl, fmt) if(lvl & dbglvl_g)	megasr_printk fmt

#ifdef DEBUG_BUILD
#define con_dbg(lvl, fmt) if(lvl & dbglvl_g)	megasr_printk fmt
#else
#define con_dbg(lvl, fmt) /* no debug information for free build */
#endif

#ifndef COMPILE_64BIT
#define MEGASR_DIV64(dividend64, divisor32) megasr_div64(dividend64, divisor32)
#define MEGASR_MOD64(dividend64, divisor32) megasr_mod64(dividend64, divisor32)
#else
#define MEGASR_DIV64(dividend64, divisor32)	((dividend64) / (divisor32))
#define MEGASR_MOD64(dividend64, divisor32)	((dividend64) % (divisor32))
#endif	// COMPILE_64BIT

#define INVALID_SECTOR			0xFFFFFFFFFFFFFFFFULL
#define	TWO_TB_SECTORS				0x100000000ULL
#define UPPER_32BIT_MASK			0xFFFFFFFF00000000ULL

#define MAX_PCI_ELEMENTS	6

#endif // LSI_MEGA_SWR_LINUX_DEFS_H

